﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

class Plane
{
    // Listing 3-43. Konstruktor statyczny
    static Plane()
    {
        Console.WriteLine("Statyczny konstruktor klasy Plane.");
    }

    public string Identifier
    {
        get;
        set;
    }

    const double kilometersPerMile = 1.609344;

    public double SpeedInMilesPerHour
    {
        get
        {
            return SpeedInKilometersPerHour / kilometersPerMile;
        }
        set
        {
            SpeedInKilometersPerHour = value * kilometersPerMile;
        }
    }

    public double SpeedInKilometersPerHour
    {
        get;
        set;
    }

    public DirectionOfApproach Direction
    {
        get;
        set;
    }

    public PolarPoint3D Position
    {
        get;
        set;
    }

    public void SendMessage(
        string messageName,
        TimeSpan delay = default(TimeSpan))
    {
    }

    public void UpdatePosition(double minutesToAdvance)
    {
        double hours = minutesToAdvance / 60;
        double milesMoved = this.SpeedInMilesPerHour * hours;
        double milesToTower = this.Position.Distance;
        if (this.Direction == DirectionOfApproach.Approaching)
        {
            milesToTower -= milesMoved;
            if (milesToTower < 0)
            {
                // Dolecieliśmy!
                milesToTower = 0;
            }
        }
        else
        {
            milesToTower += milesMoved;
        }
        PolarPoint3D newPosition = new PolarPoint3D(
            milesToTower,
            this.Position.Angle,
            this.Position.Altitude);
    }

    public static bool TooClose(Plane first, Plane second, double minimumMiles)
    {
        double x1 = first.Position.Distance * Math.Cos(first.Position.Angle);
        double x2 = second.Position.Distance * Math.Cos(second.Position.Angle);
        double y1 = first.Position.Distance * Math.Sin(first.Position.Angle);
        double y2 = second.Position.Distance * Math.Sin(second.Position.Angle);
        double z1 = first.Position.Altitude / feetPerMile;
        double z2 = second.Position.Altitude / feetPerMile;
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        double distanceSquared = dx * dx + dy * dy + dz * dz;
        double minimumSquared = minimumMiles * minimumMiles;
        return distanceSquared < minimumSquared;
    }
    private const double feetPerMile = 5280;
}